/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.StonecuttingRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class RecipeHelper {
    private static final LoadingCache<Item, Set<CompactingShape>> ITEM_COMPACTING_SHAPES = CacheBuilder.newBuilder().expireAfterAccess(120L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Item, Set<CompactingShape>>(){

        public Set<CompactingShape> load(Item item) {
            return RecipeHelper.getCompactingShapes(item);
        }
    });
    private static final int MAX_FOLLOW_UP_COMPACTING_RECIPES = 10;
    private static WeakReference<World> world;
    private static final Map<CompactedItem, CompactingResult> COMPACTING_RESULTS;

    private RecipeHelper() {
    }

    public static void setWorld(World w) {
        world = new WeakReference<World>(w);
    }

    private static Optional<World> getWorld() {
        return Optional.ofNullable((World)world.get());
    }

    private static Set<CompactingShape> getCompactingShapes(Item item) {
        return RecipeHelper.getWorld().map(w -> {
            HashSet<CompactingShape> compactingShapes = new HashSet<CompactingShape>();
            RecipeHelper.getCompactingShape(item, w, 2, 2, CompactingShape.TWO_BY_TWO_UNCRAFTABLE, CompactingShape.TWO_BY_TWO).ifPresent(compactingShapes::add);
            RecipeHelper.getCompactingShape(item, w, 3, 3, CompactingShape.THREE_BY_THREE_UNCRAFTABLE, CompactingShape.THREE_BY_THREE).ifPresent(compactingShapes::add);
            if (compactingShapes.isEmpty()) {
                compactingShapes.add(CompactingShape.NONE);
            }
            return compactingShapes;
        }).orElse(Collections.emptySet());
    }

    private static Optional<CompactingShape> getCompactingShape(Item item, World w, int width, int height, CompactingShape uncraftableShape, CompactingShape shape) {
        CompactingResult compactingResult = RecipeHelper.getCompactingResult(item, w, width, height);
        if (!compactingResult.getResult().func_190926_b()) {
            if (item == compactingResult.getResult().func_77973_b()) {
                return Optional.empty();
            }
            if (RecipeHelper.isPartOfCompactingLoop(item, compactingResult.getResult().func_77973_b(), w)) {
                return Optional.empty();
            }
            if (RecipeHelper.uncompactMatchesItem(compactingResult.getResult(), w, item, width * height)) {
                return Optional.of(uncraftableShape);
            }
            return Optional.of(shape);
        }
        return Optional.empty();
    }

    private static boolean isPartOfCompactingLoop(Item firstCompacted, Item firstCompactResult, World w) {
        int iterations = 0;
        HashSet<Item> compactedItems = new HashSet<Item>();
        LinkedList<Item> itemsToCompact = new LinkedList<Item>();
        itemsToCompact.add(firstCompactResult);
        while (!itemsToCompact.isEmpty()) {
            Item itemToCompact = (Item)itemsToCompact.poll();
            ItemStack compactingResultStack = RecipeHelper.getCompactingResult(itemToCompact, w, 2, 2).getResult();
            if (!compactingResultStack.func_190926_b()) {
                if (compactingResultStack.func_77973_b() == firstCompacted) {
                    return true;
                }
                if (compactedItems.contains(compactingResultStack.func_77973_b())) {
                    return false;
                }
                itemsToCompact.add(compactingResultStack.func_77973_b());
            }
            if (!(compactingResultStack = RecipeHelper.getCompactingResult(itemToCompact, w, 3, 3).getResult()).func_190926_b()) {
                if (compactingResultStack.func_77973_b() == firstCompacted) {
                    return true;
                }
                if (compactedItems.contains(compactingResultStack.func_77973_b())) {
                    return false;
                }
                itemsToCompact.add(compactingResultStack.func_77973_b());
            }
            compactedItems.add(itemToCompact);
            if (++iterations <= 10) continue;
            return true;
        }
        return false;
    }

    private static boolean uncompactMatchesItem(ItemStack result, World w, Item item, int count) {
        CraftingInventory craftingInventory = RecipeHelper.getFilledCraftingInventory(result.func_77973_b(), 1, 1);
        result = w.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftingInventory, w).map(r -> r.func_77572_b((IInventory)craftingInventory)).orElse(ItemStack.field_190927_a);
        return (result.func_77973_b() == item || InventoryHelper.anyItemTagMatches(result.func_77973_b(), item)) && result.func_190916_E() == count;
    }

    public static CompactingResult getCompactingResult(Item item, int width, int height) {
        return RecipeHelper.getWorld().map(w -> RecipeHelper.getCompactingResult(item, w, width, height)).orElse(CompactingResult.EMPTY);
    }

    private static CompactingResult getCompactingResult(Item item, World w, int width, int height) {
        CompactedItem compactedItem = new CompactedItem(item, width, height);
        if (COMPACTING_RESULTS.containsKey(compactedItem)) {
            return COMPACTING_RESULTS.get(compactedItem);
        }
        CraftingInventory craftingInventory = RecipeHelper.getFilledCraftingInventory(item, width, height);
        ArrayList remainingItems = new ArrayList();
        ItemStack result = w.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftingInventory, w).map(r -> {
            r.func_179532_b((IInventory)craftingInventory).forEach(stack -> {
                if (!stack.func_190926_b()) {
                    remainingItems.add(stack);
                }
            });
            return r.func_77572_b((IInventory)craftingInventory);
        }).orElse(ItemStack.field_190927_a);
        CompactingResult compactingResult = new CompactingResult(result, remainingItems);
        if (!result.func_190926_b()) {
            COMPACTING_RESULTS.put(compactedItem, compactingResult);
        }
        return compactingResult;
    }

    private static CraftingInventory getFilledCraftingInventory(Item item, int width, int height) {
        CraftingInventory craftinginventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, width, height);
        for (int i = 0; i < craftinginventory.func_70302_i_(); ++i) {
            craftinginventory.func_70299_a(i, new ItemStack((IItemProvider)item));
        }
        return craftinginventory;
    }

    public static Optional<FurnaceRecipe> getSmeltingRecipe(ItemStack stack) {
        return RecipeHelper.getWorld().flatMap(w -> w.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{stack}))), w));
    }

    public static Set<CompactingShape> getItemCompactingShapes(Item item) {
        return (Set)ITEM_COMPACTING_SHAPES.getUnchecked((Object)item);
    }

    public static List<StonecuttingRecipe> getStonecuttingRecipes(IInventory inventory) {
        return RecipeHelper.getWorld().map(w -> w.func_199532_z().func_215370_b(IRecipeType.field_222154_f, inventory, w)).orElse(Collections.emptyList());
    }

    static {
        COMPACTING_RESULTS = new HashMap<CompactedItem, CompactingResult>();
    }

    private static class CompactedItem {
        private final Item item;
        private final int width;
        private final int height;

        private CompactedItem(Item item, int width, int height) {
            this.item = item;
            this.width = width;
            this.height = height;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompactedItem that = (CompactedItem)o;
            return this.width == that.width && this.height == that.height && this.item.equals(that.item);
        }

        public int hashCode() {
            return Objects.hash(this.item, this.width, this.height);
        }
    }

    public static class CompactingResult {
        public static final CompactingResult EMPTY = new CompactingResult(ItemStack.field_190927_a, Collections.emptyList());
        private final ItemStack result;
        private final List<ItemStack> remainingItems;

        private CompactingResult(ItemStack result, List<ItemStack> remainingItems) {
            this.result = result;
            this.remainingItems = remainingItems;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public List<ItemStack> getRemainingItems() {
            return this.remainingItems;
        }
    }

    public static enum CompactingShape {
        NONE,
        THREE_BY_THREE,
        TWO_BY_TWO,
        THREE_BY_THREE_UNCRAFTABLE,
        TWO_BY_TWO_UNCRAFTABLE;

    }
}

